/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.ui.bonsai.table;

import com.ibm.hwmca.fw.servlet.util.HMCSession;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.ui.bonsai.earth.TaskNode;
import com.ibm.hwmca.ui.bonsai.servlet.util.UISession;
import com.ibm.hwmca.ui.bonsai.table.NameTableCellBean;
import com.ibm.hwmca.ui.bonsai.table.SystemNameTableCell;
import com.ibm.psw.wcl.components.menu.IMenuItem;
import com.ibm.psw.wcl.components.menu.MenuInfo;
import com.ibm.psw.wcl.components.menu.MenuItemInfo;
import com.ibm.psw.wcl.components.menu.WPopupMenu;
import com.ibm.psw.wcl.components.table.WTable;
import com.ibm.psw.wcl.core.RenderingContext;
import com.ibm.psw.wcl.core.WComponent;
import com.ibm.psw.wcl.core.cell.AWCell;
import com.ibm.psw.wcl.core.cell.CellInfo;
import com.ibm.psw.wcl.core.markup.WHyperlink;
import com.ibm.psw.wcl.core.markup.WImage;
import com.ibm.psw.wcl.core.markup.WTextComponent;
import com.ibm.psw.wcl.core.renderer.RendererException;
import com.ibm.psw.wcl.core.renderer.output.IOutput;
import com.ibm.psw.wcl.renderers.cell.html.HTMLDefaultCellRenderer;
import java.util.Iterator;
import java.util.List;

public class SystemTableCellRenderer
extends HTMLDefaultCellRenderer {
    private static final String TRACEMASK_T = "XPTRTCRT";
    private static final String TRACEMASK_F = "XPTRTCRF";
    private static final String TRACEMASK_D = "XPTRTCRD";

    public IOutput renderCell(RenderingContext rc, AWCell cell, CellInfo info) throws RendererException {
        if (cell instanceof SystemNameTableCell) {
            cell = this.prepareCell(rc, (SystemNameTableCell)cell, info);
            IOutput iOutput = cell.getOutput(rc);
            cell.removeAll();
            return iOutput;
        }
        return super.renderCell(rc, cell, info);
    }

    public SystemNameTableCell prepareCell(RenderingContext rc, SystemNameTableCell cell, CellInfo cellInfo) {
        Trace.trace(TRACEMASK_D, "-> SystemTableCellRenderer.prepareCell()");
        Object val = cellInfo.getValue();
        if (val != null && val instanceof NameTableCellBean) {
            WComponent comp;
            HMCSession hmcSession;
            UISession uis;
            List lTaskNodes;
            NameTableCellBean tnode = (NameTableCellBean)val;
            String text = tnode.getText();
            String url = tnode.getUrl();
            String image = tnode.getImageName();
            String id = tnode.getId();
            if (image != null) {
                WImage wImage = new WImage(rc.getResourceURL(image));
                wImage.setWidth("16");
                wImage.setHeight("16");
                cell.add((WComponent)wImage);
            }
            if (url == null) {
                cell.add((WComponent)new WTextComponent(text));
            } else {
                cell.add((WComponent)new WHyperlink(url, text));
            }
            if (cellInfo.getSelected() && (lTaskNodes = (uis = UISession.getUISession(hmcSession = HMCSession.getHMCSession(rc.getSession(false)))).getResourceTaskTrees()) != null && !lTaskNodes.isEmpty()) {
                MenuInfo root = new MenuInfo();
                this.buildMenuItems(root, lTaskNodes);
                if (root.getChildCount() > 0) {
                    WPopupMenu popup = new WPopupMenu((IMenuItem)root);
                    popup.setID("ResourcesWorkareaContextMenuId");
                    popup.setVisible(true);
                    cell.add((WComponent)popup);
                }
            }
            if (!cellInfo.getSelected() && (comp = cell.findChildComponent("ResourcesWorkareaContextMenuId")) != null) {
                cell.remove(comp);
            }
        }
        return cell;
    }

    private void buildMenuItems(MenuInfo root, List lTaskNodes) {
        TaskNode tNode = null;
        Iterator iter = lTaskNodes.iterator();
        while (iter.hasNext()) {
            tNode = (TaskNode)iter.next();
            List lTaskNodeChildren = tNode.getChildren();
            if (lTaskNodeChildren != null && lTaskNodeChildren.size() > 0) {
                MenuInfo group = new MenuInfo(tNode.getName());
                root.addChild((IMenuItem)group);
                this.buildMenuItems(group, lTaskNodeChildren);
                continue;
            }
            String str = tNode.getName();
            if (str != null) {
                str = str.replace('\n', ' ');
            }
            MenuItemInfo mi = new MenuItemInfo();
            mi.setText(str);
            mi.setOnClick("document.location.href = '" + tNode.getUrl() + "'");
            root.addChild((IMenuItem)mi);
        }
    }

    private boolean isSingleRowSelected(CellInfo cellInfo) {
        boolean selected = ((WTable)cellInfo.getOwnerComponent()).getModel().getSelectedModelRowCount() == 1;
        return true;
    }
}

